% Matlab program to draw phase diagrams in the baseline Diamond overlapping generations model.
% By Marc P. B. Klemp, November 2009.

function R = R(k)
global a b p d Prod_type;
if Prod_type == 1
    R = a*((b*k^p + 1 - b)^(1/p))*(b*k^p) / (k*(b*k^p + 1 - b)) - d; % This particular expression corresponds to partial f/ partial k - d
                                                                     % where the production function in AF.m is a a CES production funtion, F
                                                                     % (i.e. this expression must correspond to the production function in AF.m)

elseif Prod_type == 2                                                % This one corresponds to the case where the production function is the
    R = a*b*k^(b-1) - d;                                             % Cobb-Douglas production function

elseif Prod_type == 3                                                % And this one corresponds to the case where the production function is the
    R = a/(1+k)-a*k/((1+k)^2) - d;                                   % third production function
end